 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/

 #ifndef __BSQUEUE6_H
 #define __BSQUEUE6_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class BSQueue6 : public Atomic
 {
   public:
	       BSQueue6( const std::string &name = "BSQueue6" );	//Default constructor
	       virtual std::string className() const { return "BSQueue6"; }
	       ~BSQueue6();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &IB0,&IB1,&IB2,&IB3,&IB4,&IB5,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class BSQueue6

 #endif   //__BSQUEUE6_H
